'Light Bright Circles
option base 0
dim string  save_bmp$
dim integer i, j, k, r
dim integer circle_size 'for example, 8 = pixel radius of circle
dim integer pen_color, cursor_xpos, cursor_ypos
dim integer pen_down '0 = pen is up / 1 = pen is down

mode 15, 8 '1280 x 1024, 256 colors
font 3 '16x24
circle_size = 8 : pen_color = 2 : pen_down = 0
main()

sub main
  map_colors()
  color rgb(gray), rgb(black)
  cls
  text 16,  24, "Cursor Left = travel LEFT one space"
  text 16,  48, "Cursor Right = travel RIGHT one space"
  text 16,  72, "Cursor Up = travel UP one space"
  text 16,  96, "Cursor Down = travel DOWN one space"
  text 16, 120, "- = Change (Decrease) Pen Color"
  text 16, 144, "= = Change (Increase) Pen Color"
  text 16, 168, "h = Hide cursor"
  text 16, 192, "s = Show cursor"
  text 16, 216, "d = Decrease circle size"
  text 16, 240, "i = Increase circle size"
  text 16, 264, "o = place One peg/circle"
  text 16, 288, "p = Toggle Pen UP / Pen DOWN"  
  text 16, 312, "r = Remove peg/circle"
  text 16, 336, "F1 = Save sketch"
  text 16, 360, "F5 = Load sketch"
  text 16, 384, "F9 = Clear screen"
  text 16, 432, "Press Enter or Space Bar to continue..."
  do
    if keydown(1) = 10 or keydown(1) = 32 then exit do
  loop   
  cursor_xpos = 640 : cursor_ypos = 512
  gui cursor on 1, cursor_xpos, cursor_ypos
  draw()
end sub

sub draw
  color rgb(gray), rgb(black)
  cls
  do
    pause 45
    if keydown(0) = 2 then
      if (keydown(1) = 128 and keydown(2) = 130) or (keydown(1) = 130 and keydown(2) = 128) then 'UL
        if cursor_xpos - 2 * circle_size - 2  >= 0 and cursor_ypos - 2 * circle_size - 2 >= 0 then
          text 0, 0, "             " 
          inc cursor_xpos, -2 * circle_size - 2 : inc cursor_ypos, -2 * circle_size - 2
          gui cursor cursor_xpos, cursor_ypos
          pend()
        endif
      endif
      if (keydown(1) = 128 and keydown(2) = 131) or (keydown(1) = 131 and keydown(2) = 128) then 'UR
        if cursor_xpos + 2 * circle_size + 2 < 1280 and cursor_ypos - 2 * circle_size - 2 >= 0 then 
          text 0, 0, "             "
          inc cursor_xpos, 2 * circle_size + 2 : inc cursor_ypos, -2 * circle_size - 2
          gui cursor cursor_xpos, cursor_ypos
          pend()
        endif
      endif
      if (keydown(1) = 129 and keydown(2) = 130) or (keydown(1) = 130 and keydown(2) = 129) then 'DL
        if cursor_xpos - 2 * circle_size - 2 >= 0 and cursor_ypos + 2 * circle_size + 2 < 1024 then 
          text 0, 0, "             "
          inc cursor_xpos, -2 * circle_size - 2 : inc cursor_ypos, 2 * circle_size + 2
          gui cursor cursor_xpos, cursor_ypos
          pend()
        endif
      endif
      if (keydown(1) = 129 and keydown(2) = 131) or (keydown(1) = 131 and keydown(2) = 129) then 'DR
        if cursor_xpos + 2 * circle_size + 2 < 1280 and cursor_ypos + 2 * circle_size + 2 < 1024 then 
          text 0, 0, "             "
          inc cursor_xpos, 2 * circle_size + 2 : inc cursor_ypos, 2 * circle_size + 2
          gui cursor cursor_xpos, cursor_ypos
          pend()
        endif
      endif
    elseif keydown(0) = 1 then
      select case keydown(1)
        case 128 'Cursor up 
          if cursor_ypos - 2 * circle_size - 2 >= 0 then 
            text 0, 0, "             "
            inc cursor_ypos, -2 * circle_size - 2
            gui cursor cursor_xpos, cursor_ypos
            pend()
          endif               
        case 129 'Cursor down 
          if cursor_ypos + 2 * circle_size + 2 < 1024 then
            text 0, 0, "             "
            inc cursor_ypos, 2 * circle_size + 2
            gui cursor cursor_xpos, cursor_ypos
            pend()
          endif
        case 130 'Cursor left
          if cursor_xpos - 2 * circle_size - 2 >= 0 then
            text 0, 0, "             "
            inc cursor_xpos, -2 * circle_size - 2
            gui cursor cursor_xpos, cursor_ypos
            pend()
          endif
        case 131 'Cursor right
          if cursor_xpos + 2 * circle_size + 2 < 1280 then
            text 0, 0, "             "
            inc cursor_xpos, 2 * circle_size + 2
            gui cursor cursor_xpos, cursor_ypos
            pend()
          endif
        case 45 '- Change (decrease) pen color 
          if pen_color = 0 then
            pen_color = 255
          else
            inc pen_color, -1
          endif
          color map(pen_color), rgb(black) 'gray
          text 0, 0, "             "
          text 0, 0, str$(pen_color)
          pause 150
        case 43, 61 '= or + Change (increase) pen color
          if pen_color = 255 then
            pen_color = 0
          else
            inc pen_color
          endif
          color map(pen_color), rgb(black) 'gray
          text 0, 0, "             "
          text 0, 0, str$(pen_color)
          pause 150
        case 104 'h = Hide cursor
          gui cursor hide 
        case 115 's = Show cursor
          gui cursor show
        case 105 'i = increase circle size
          if circle_size = 40 then
            circle_size = 40 
          else
            inc circle_size
          endif
          text 0, 0, "             "
          text 0, 0, "cs = " + str$(circle_size)
          pause 40
        case 100 'd = decrease circle size
          if circle_size = 1 then
            circle_size = 1
          else
            inc circle_size, -1
          endif
          text 0, 0, "             "
          text 0, 0, "cs = " + str$(circle_size)
          pause 40
        case 111 'o = place One peg/circle
          circle cursor_xpos, cursor_ypos, circle_size, 1,, map(pen_color), map(pen_color)
          pause 40
        case 114 'r = Remove peg/circle
          circle cursor_xpos, cursor_ypos, circle_size, 1,, rgb(black), rgb(black)
          pause 40
        case 112 'p / Toggle pen up <--> pen down
          if pen_down = 0 then pen_down = 1 else pen_down = 0
          pend()
          pause 150
        case 145 'F1 / Save sketch  time is HH:MI:SS.SSS
          save image date$ + " " + left$(time$, 2) + mid$(time$, 4, 2) + mid$(time$, 7, 2) 
        case 149 'F5 / Load sketch
          text x, y, ""
          input saved_bmp$
          cls
          load bmp saved_bmp$
        case 153 'F9 / Clear screen
          color rgb(gray), rgb(black) : cls
      end select
    endif  
  loop
end sub

sub pend
  if pen_down = 1 then
    text 0, 0, "             "
    circle cursor_xpos, cursor_ypos, circle_size, 1,, map(pen_color), map(pen_color)
  else
    text 0, 0, "             "
  endif
end sub

sub map_colors
  map( 0) = rgb(  0,   0,   0) 'Black (so can erase)
  map( 1) = rgb(128, 128, 128) 'Gray
  map( 2) = rgb(255, 255, 255) 'White
  map( 3) = rgb(255,   0,   0) 'Red
  map( 4) = rgb(  0, 128,   0) 'Green
  map( 5) = rgb(  0,   0, 255) 'Blue
  map( 6) = rgb(255, 165,   0) 'Orange
  map( 7) = rgb(255, 255,   0) 'Yellow
  map( 8) = rgb(128,   0, 128) 'Purple
  map( 9) = rgb(165,  42,  42) 'Brown
  map(10) = rgb(255, 192, 203) 'Pink
  map(11) = rgb(  0, 255,   0) 'Lime
  map(12) = rgb(210, 180, 140) 'Tan
  map(13) = rgb(  0, 255, 255) 'Cyan
  map(14) = rgb(  0, 128, 128) 'Teal
  map(15) = rgb( 64, 224, 208) 'Turquoise
  map(16) = rgb(255,  69,   0) 'Orange Red
  map(17) = rgb(154, 205,  50) 'Yellow Green
  map(18) = rgb(128, 128,   0) 'Olive
  map(19) = rgb(  0,   0, 128) 'Navy
  map(20) = rgb(211, 211, 211) 'Light Gray 
  map(21) = rgb(128,   0,   0) 'Maroon
  map(22) = rgb(255, 215,   0) 'Gold
  map(23) = rgb(  0, 100,   0) 'Dark Green
  map(24) = rgb(173, 216, 230) 'Light Blue
  map(25) = rgb(230, 230, 250) 'Lavender
  map(26) = rgb(  0,   0, 139) 'Dark Blue
  map(27) = rgb(238, 130, 238) 'Violet
  map(28) = rgb(245, 245, 220) 'Beige
  map(29) = rgb(192, 192, 192) 'Silver
  map(30) = rgb(255, 140,   0) 'Dark Orange
  map(31) = rgb(210, 105,  30) 'Chocolate 
  map(32) = rgb( 34, 139,  34) 'Forest Green
  map(33) = rgb(139,   0,   0) 'Dark Red
  map(34) = rgb(  0, 255,   0) 'Lime
  map(35) = rgb( 50, 205,  50) 'Lime Green
  map(36) = rgb(  0,   0, 205) 'Medium Blue
  map(37) = rgb(178,  34,  34) 'Firebrick
  map(38) = rgb(144, 238, 144) 'Light Green
  map(39) = rgb(220,  20,  60) 'Crimson
  map(40) = rgb(152, 251, 152) 'Pale Green
  map(41) = rgb( 65, 105, 225) 'Royal Blue
  map(42) = rgb(143, 188, 143) 'Dark Sea Green 
  map(43) = rgb(138,  43, 226) 'Blue Violet
  map(44) = rgb(255,  99,  71) 'Tomato
  map(45) = rgb(  0, 250, 154) 'Medium Spring Green
  map(46) = rgb( 75,   0, 130) 'Indigo
  map(47) = rgb(255, 127,  80) 'Coral
  map(48) = rgb(  0, 255, 127) 'Spring Green
  map(49) = rgb( 72,  61, 139) 'Dark Slate Blue
  map(50) = rgb(205,  92,  92) 'Indian Red
  map(51) = rgb( 46, 139,  87) 'Sea Green
  map(52) = rgb(106,  90, 205) 'Slate Blue
  map(53) = rgb(240, 128, 128) 'Light Coral
  map(54) = rgb(102, 205, 170) 'Medium Aquamarine
  map(55) = rgb(123, 104, 238) 'Medium Slate Blue
  map(56) = rgb(233, 150, 122) 'Dark Salmon
  map(57) = rgb( 60, 179, 113) 'Medium Sea Green
  map(58) = rgb(147, 112, 219) 'Medium Purple
  map(59) = rgb(250, 128, 114) 'Salmon
  map(60) = rgb( 32, 178, 170) 'Light Sea Green
  map(61) = rgb(139,   0, 139) 'Dark Magenta
  map(62) = rgb(255, 160, 122) 'Light Salmon
  map(63) = rgb( 47,  79,  79) 'Dark Slate Gray
  map(64) = rgb(148,   0, 211) 'Dark Violet
  map(65) = rgb(153,  50, 204) 'Dark Orchid
  map(66) = rgb(  0, 139, 139) 'Dark Cyan
  map(67) = rgb(186,  85, 211) 'Medium Orchid
  map(68) = rgb(224, 255, 255) 'Light Cyan
  map(69) = rgb(216, 191, 216) 'Thistle
  map(70) = rgb(184, 134,  11) 'Dark Goldenrod
  map(71) = rgb(  0, 206, 209) 'Dark Turquoise
  map(72) = rgb(221, 160, 221) 'Plum
  map(73) = rgb(218, 165,  32) 'Goldenrod
  map(74) = rgb(238, 232, 170) 'Pale Goldenrod
  map(75) = rgb( 72, 209, 204) 'Medium Turquoise
  map(76) = rgb(255,  10, 255) 'Magenta
  map(77) = rgb(189, 183, 107) 'Dark Khaki
  map(78) = rgb(175, 238, 238) 'Pale Turquoise
  map(79) = rgb(218, 112, 214) 'Orchid
  map(80) = rgb(240, 230, 140) 'Khaki
  map(81) = rgb(127, 255, 212) 'Aquamarine
  map(82) = rgb(199,  21, 133) 'Medium Violet Red
  map(83) = rgb(176, 224, 230) 'Powder Blue
  map(84) = rgb(219, 112, 147) 'Pale Violet Red
  map(85) = rgb( 95, 158, 160) 'Cadet Blue
  map(86) = rgb(255,  20, 147) 'Deep Pink
  map(87) = rgb( 70, 130, 180) 'Steel Blue
  map(88) = rgb(255, 105, 180) 'Hot Pink
  map(89) = rgb( 85, 107,  47) 'Dark Olive Green
  map(90) = rgb(100, 149, 237) 'Corn Flower Blue
  map(91) = rgb(255, 182, 193) 'Light Pink
  map(92) = rgb(107, 142,  35) 'Olive Drab
  map(93) = rgb(  0, 191, 255) 'Deep Sky Blue
  map(94) = rgb(124, 252,   0) 'Lawn Green
  map(95) = rgb( 30, 144, 255) 'Dodger Blue
  map(96) = rgb(250, 235, 215) 'Antique White
  map(97) = rgb(127, 255,   0) 'Chart Reuse
  map(98) = rgb(173, 255,  47) 'Green Yellow
  map(99) = rgb(135, 206, 235) 'Sky Blue
  map(100) = rgb(255, 228, 196) 'Bisque
  map(101) = rgb(135, 206, 250) 'Light Sky Blue
  map(102) = rgb(255, 235, 205) 'Blanched Almond
  map(103) = rgb( 25,  25, 112) 'Midnight Blue
  map(104) = rgb(245, 222, 179) 'Wheat
  map(105) = rgb(255, 248, 220) 'Corn Silk
  map(106) = rgb(255, 240, 245) 'Lavender Blush
  map(107) = rgb(255, 250, 205) 'Lemon Chiffon
  map(108) = rgb(250, 240, 230) 'Linen
  map(109) = rgb(245, 245, 245) 'White Smoke
  map(110) = rgb(250, 250, 210) 'Light Yellow Gold
  map(111) = rgb(253, 245, 230) 'Old Lace
  map(112) = rgb(220, 220, 220) 'Gainsboro
  map(113) = rgb(255, 255, 224) 'Light Yellow
  map(114) = rgb(255, 239, 213) 'Papaya Whip
  map(115) = rgb(139,  69,  19) 'Saddle Brown
  map(116) = rgb(255, 245, 238) 'Sea Shell
  map(117) = rgb(160,  82,  45) 'Sienna
  map(118) = rgb(245, 255, 250) 'Mint Cream
  map(119) = rgb(169, 169, 169) 'Dark Gray
  map(120) = rgb(112, 128, 144) 'Slate Gray
  map(121) = rgb(205, 133,  63) 'Peru
  map(122) = rgb(119, 136, 153) 'Light Slate Gray
  map(123) = rgb(105, 105, 105) 'Dim Gray
  map(124) = rgb(244, 164,  96) 'Sandy Brown
  map(125) = rgb(176, 196, 222) 'Light Steel Blue
  map(126) = rgb(222, 184, 135) 'Burly Wood
  map(127) = rgb(255, 250, 250) 'Snow
  map(128) = rgb(255, 250, 240) 'Floral White
  map(129) = rgb(255, 228, 225) 'Misty Rose 
  map(130) = rgb(188, 143, 143) 'Rosy Brown
  map(131) = rgb(240, 248, 255) 'Alice Blue
  map(132) = rgb(255, 218, 185) 'Peach Puff
  map(133) = rgb(255, 228, 181) 'Moccasin
  map(134) = rgb(248, 248, 255) 'Ghost White
  map(135) = rgb(240, 255, 255) 'Azure
  map(136) = rgb(255, 222, 173) 'Novajo White
  map(137) = rgb(240, 255, 240) 'Honeydew
  map(138) = rgb(255, 255, 240) 'Ivory
  map set
end sub








































